//
//  GlyphsToolProtocol.h
//  GlyphsCore
//
//  Created by Martin Winter on 20.06.18.
//  Copyright © 2018 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN

@protocol GSWindowControllerProtocol;
@protocol GSGlyphEditViewControllerProtocol;

@protocol GlyphsTool <NSObject>

/// The main window controller.
@property (weak, nullable) NSWindowController<GSWindowControllerProtocol> *windowController;

/// The current editView controller controller.
@property (weak, nullable) NSViewController<GSGlyphEditViewControllerProtocol> *editViewController;

- (NSCursor *)standardCursor;

@end

NS_ASSUME_NONNULL_END
